const express = require("express");
const bodyParser = require("body-parser");
const cors = require("cors");
require("dotenv").config();

// Import routes
const classRoutes = require("./routes/classRoutes");
const courseRoutes = require("./routes/courseRoutes");
const subjectRoutes = require("./routes/subjectRoutes");
const studentRoutes = require("./routes/studentRoutes");
const marksRoutes = require("./routes/marksRoutes");
const authRoutes = require("./routes/authRoutes");
const sessionsRoutes = require("./routes/sessionsRoutes");
const studentsReportRoutes = require("./routes/studentsreportRoutes");
const performanceRoutes = require("./routes/performanceRoutes"); // Import the performance routes

const app = express();

// Middleware
app.use(cors());
app.use(bodyParser.json());

// Routes
app.use("/api/class", classRoutes);
app.use("/api/sessions", sessionsRoutes);
app.use("/api/report", studentsReportRoutes);
app.use("/api/course", courseRoutes);
app.use("/api/subject", subjectRoutes);
app.use("/api/student", studentRoutes);
app.use("/api/marks", marksRoutes);
app.use("/api/auth", authRoutes);
app.use("/api/performance", performanceRoutes); // Add the performance routes

// Start server
const PORT = process.env.PORT || 5000;
app.listen(PORT, () => {
  console.log(`Server is running on port ${PORT}`);
});
